/*
 * server_status_display.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SERVER_STATUS_DISPLAY_HPP
#define SERVER_STATUS_DISPLAY_HPP

#include "status_display.hpp"

#include <vector>

class ServerStatusDisplay : public StatusDisplay {
public:
    typedef unsigned char ubyte;
    explicit ServerStatusDisplay(std::vector<ubyte> &out_) : out(out_) { }

    virtual void setBackpack(int slot, const Graphic *gfx, const Graphic *overdraw, int no_carried, int no_max);
    virtual void addSkull();
    virtual void setHealth(int h);
    virtual void setPotionMagic(PotionMagic pm, bool poison_immunity);
    virtual void setQuestMessage(const std::string &msg);
    virtual void setQuestIcons(const std::vector<StatusDisplay::QuestIconInfo> &icons);
    
private:
    std::vector<ubyte> &out;
};

#endif
