/*
 * server_status_display.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "graphic.hpp"
#include "protocol.hpp"
#include "server_status_display.hpp"

void ServerStatusDisplay::setBackpack(int slot, const Graphic *gfx, const Graphic *overdraw, int no_carried, int no_max)
{
    Coercri::OutputByteBuf buf(out);
    buf.writeUbyte(SERVER_SET_BACKPACK);
    buf.writeUbyte(slot);
    buf.writeVarInt(gfx ? gfx->getID() : 0);
    buf.writeVarInt(overdraw ? overdraw->getID() : 0);
    buf.writeUbyte(no_carried);
    buf.writeUbyte(no_max);
}

void ServerStatusDisplay::addSkull()
{
    Coercri::OutputByteBuf buf(out);
    buf.writeUbyte(SERVER_ADD_SKULL);
}

void ServerStatusDisplay::setHealth(int h)
{
    Coercri::OutputByteBuf buf(out);
    buf.writeUbyte(SERVER_SET_HEALTH);
    buf.writeVarInt(h);
}

void ServerStatusDisplay::setPotionMagic(PotionMagic pm, bool poison_immunity)
{
    Coercri::OutputByteBuf buf(out);
    buf.writeUbyte(SERVER_SET_POTION_MAGIC);
    buf.writeUbyte((poison_immunity?128:0) + int(pm));
}

void ServerStatusDisplay::setQuestMessage(const std::string &msg)
{
    Coercri::OutputByteBuf buf(out);
    buf.writeUbyte(SERVER_SET_QUEST_MESSAGE);
    buf.writeString(msg);
}

void ServerStatusDisplay::setQuestIcons(const std::vector<StatusDisplay::QuestIconInfo> &icons)
{
    Coercri::OutputByteBuf buf(out);
    buf.writeUbyte(SERVER_SET_QUEST_ICONS);
    buf.writeUbyte(icons.size());
    for (int i = 0; i < icons.size(); ++i) {
        buf.writeUbyte(icons[i].num_held);
        buf.writeUbyte(icons[i].num_required);
        buf.writeVarInt(icons[i].gfx_missing ? icons[i].gfx_missing->getID() : 0);
        buf.writeVarInt(icons[i].gfx_held ? icons[i].gfx_held->getID() : 0);
    }
}
