/*
 * server_mini_map.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SERVER_MINI_MAP_HPP
#define SERVER_MINI_MAP_HPP

#include "mini_map.hpp"

#include <map>
#include <vector>

class ServerMiniMap : public MiniMap {
public:
    typedef unsigned char ubyte;
    explicit ServerMiniMap(std::vector<ubyte> &out_) : out(out_) { }

    void appendMiniMapCmds(std::vector<ubyte> &vec) const;
    void clearMiniMapCmds() { mini_map_runs.clear(); }
    
    virtual void setSize(int width, int height);
    virtual void setColour(int x, int y, MiniMapColour col);
    virtual void wipeMap();
    virtual void mapKnightLocation(int n, int x, int y);
    virtual void mapItemLocation(int x, int y, bool on);
    
private:
    std::vector<ubyte> &out;

    struct MiniMapRun {
        int start_x;
        int y;
        std::vector<MiniMapColour> cols;
    };
    std::vector<MiniMapRun> mini_map_runs;

    // caching
    struct KtLocn {
        int x;
        int y;
    };
    std::map<int, KtLocn> prev_kt_locn;
};

#endif
