/*
 * server_dungeon_view.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SERVER_DUNGEON_VIEW_HPP
#define SERVER_DUNGEON_VIEW_HPP

#include "dungeon_view.hpp"

#include <vector>

class ServerDungeonView : public DungeonView {
public:
    typedef unsigned char ubyte;
    
    explicit ServerDungeonView(std::vector<ubyte> &out_) : out(out_) { }

    virtual void setCurrentRoom(int r, int width, int height);

    virtual void addEntity(unsigned short int id, int x, int y, MapHeight ht, MapDirection facing,
                           const Anim * anim, const Overlay *ovr, int af, int atz_diff,
                           bool ainvuln, // (anim data)
                           int cur_ofs, MotionType motion_type, int motion_time_remaining);
    virtual void rmEntity(unsigned short int id);
    virtual void repositionEntity(unsigned short int id, int new_x, int new_y);
    virtual void moveEntity(unsigned short int id, MotionType motion_type,
                            int motion_duration, bool missile_mode);
    virtual void flipEntityMotion(unsigned short int id, int initial_delay, int motion_duration);
    virtual void setAnimData(unsigned short int id, const Anim *, const Overlay *, int af,
                             int atz_diff, bool ainvuln, bool currently_moving);
    virtual void setFacing(unsigned short int id, MapDirection new_facing);

    virtual void clearTiles(int x, int y);
    virtual void setTile(int x, int y, int depth, const Graphic *gfx, boost::shared_ptr<const ColourChange> cc);

    virtual void setItem(int x, int y, const Graphic *gfx);

    virtual void placeIcon(int x, int y, const Graphic *gfx, int dur);

    virtual void flashMessage(const std::string &msg, int ntimes);
    virtual void cancelContinuousMessages();
    virtual void addContinuousMessage(const std::string &msg);

private:
    std::vector<ubyte> &out;
};

#endif
