/*
 * server_callbacks.hpp
 *
 * Implementation of KnightsCallbacks that writes binary data to a
 * buffer.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SERVER_CALLBACKS_HPP
#define SERVER_CALLBACKS_HPP

#include "knights_callbacks.hpp"

#include <memory>

class ServerDungeonView;
class ServerMiniMap;
class ServerStatusDisplay;

class ServerCallbacks : public KnightsCallbacks {
public:
    typedef unsigned char ubyte;
    
    ServerCallbacks();
    virtual ~ServerCallbacks();

    // methods to append queued cmds to the given vector.
    void appendPlayerCmds(int plyr, std::vector<ubyte> &cmds) const;
    void appendObserverCmds(std::vector<ubyte> &cmds) const;

    // query game over state
    bool isGameOver() const { return game_over; }
    int getWinnerNum() const { return winner_num; } // plyr num of the winner, valid if isGameOver() true.
    
    // clear queued cmds.
    void clearCmds();

    // functions overridden from KnightsCallbacks
    virtual DungeonView & getDungeonView(int plyr);
    virtual MiniMap & getMiniMap(int plyr);
    virtual StatusDisplay & getStatusDisplay(int plyr);

    virtual void playSound(int plyr, const Sound &sound, int frequency);

    virtual void winGame(int plyr);
    virtual void loseGame(int plyr);

    virtual void setAvailableControls(int plyr, const std::vector<std::pair<const UserControl*, bool> > &available_controls);
    virtual void setMenuHighlight(int plyr, const UserControl *highlight);

    virtual void flashScreen(int plyr, int delay);

private:
    std::auto_ptr<ServerDungeonView> dungeon_view[2];
    std::auto_ptr<ServerMiniMap> mini_map[2];
    std::auto_ptr<ServerStatusDisplay> status_display[2];

    // output buffers
    std::vector<ubyte> pub[2], prv[2], all;

    // caching
    const UserControl* prev_menu_highlight[2];

    bool game_over;
    int winner_num;
};

#endif
