/*
 * rstream_rwops.hpp
 *
 * Create an SDL_RWops structure from an rstream.
 * Note that it will be read-only; the write functions will fail (returning -1).
 *
 * NB: Could easily convert this to a general "iostream_rwops" class.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef RSTREAM_RWOPS_HPP
#define RSTREAM_RWOPS_HPP

#include "rstream.hpp"

#include <SDL_rwops.h>


// At the moment can load only from a resource name,
// but extension to loading from a given rstream is easy.
// The returned ptr must be freed in usual way (using SDL_RWclose)
SDL_RWops* RWFromRStream(const string &resource_name);

#endif  // RSTREAM_RWOPS_HPP
