/*
 * rstream_rwops.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "rstream_rwops.hpp"

namespace {

int Rseek(SDL_RWops *context, int offset, int whence)
{
	RStream *str = static_cast<RStream *>(context->hidden.unknown.data1);
	switch (whence) {
	case SEEK_SET:
		str->seekg(offset, ios_base::beg);
		break;
	case SEEK_CUR:
		str->seekg(offset, ios_base::cur);
		break;
	case SEEK_END:
		str->seekg(offset, ios_base::end);
		break;
	default:
		return -1; // error
	}
	if (!str) return -1;
	else return str->tellg();
}

int Rread(SDL_RWops *context, void *ptr, int size, int maxnum)
{
	RStream *str = static_cast<RStream *>(context->hidden.unknown.data1);
	str->read(static_cast<char*>(ptr), size*maxnum);
	if (!str) return -1;
	else return str->gcount() / size;
}

int Rwrite(SDL_RWops *context, const void *ptr, int size, int maxnum)
{
	return -1; // read only!
}

int Rclose(SDL_RWops *context)
{
	RStream *str = static_cast<RStream *>(context->hidden.unknown.data1);
	delete str;
	delete context;
	return 0;
}

}  // namespace


SDL_RWops* RWFromRStream(const string &resource_name)
{
	// hmm, not quite exception safe. that's the price of a c-like interface
	// (although could write a c++ wrapper i guess).
	SDL_RWops *rw = new SDL_RWops;
	RStream *str = new RStream(resource_name);
	rw->seek = &Rseek;
	rw->read = &Rread;
	rw->write = &Rwrite;
	rw->close = &Rclose;
	rw->hidden.unknown.data1 = static_cast<void*>(str);
	return rw;
}
