/*
 * rstream.hpp
 * Resource streams. Like ifstream except we load from "resources" rather than files.
 * A resource is currently just a file (but loaded from a standard path, so we don't have to worry about
 * current working directory etc), but in the future could be some sort of virtual file system.
 *
 * API:
 * RStream rs("fred.txt");   (%%% perhaps a more url like syntax in future?)
 *  -- the system will automatically find fred.txt from the "standard" location(s)
 * Then manipulate rs as an ordinary istream.
 *
 * The standard location is currently "." but can optionally be reset by calling
 * RStream::Initialize(path); eg if(argc>1)RStream::Initialize(argv[1]); is useful for testing.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef RSTREAM_HPP
#define RSTREAM_HPP

#include <string>
#include <istream>
#include <fstream>
#include <exception>
using namespace std;

class RStreamError : public std::exception {
public:
	RStreamError(const string &r, const string &e);
	virtual ~RStreamError() throw() { }
	const string &getResource() const { return resource; }
	const string &getErrorMsg() const { return error_msg; }
	const char *what() const throw();

private:
	string resource, error_msg, what_str;
};


class RStream : public istream {
public:
	static void Initialize(const string &resource_path_);
	explicit RStream(const string &resource_name);
	~RStream();

private:
	// at the moment we only implement by using a filebuf. could add a custom stream buffer
	// to do more sophisticated stuff. (but still want rstream itself to inherit from istream.)
	filebuf my_filebuf;
	enum { BUFSIZE = 1024 };
	char buffer[BUFSIZE];
	static string resource_path;
	static bool initialized;
};

#endif  // RSTREAM_HPP
