/*
 * rstream.cpp
 *
 * To do:
 * More advanced RStreamError class?
 * Consideration of text vs binary files?
 * Add support for vfs / maybe a url like syntax.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "rstream.hpp"

RStreamError::RStreamError(const string &r, const string &e)
    : resource(r), error_msg(e)
{
    what_str = "error loading '" + getResource() +
        "': " + getErrorMsg();
}

const char *RStreamError::what() const throw()
{
    return what_str.c_str();
}


string RStream::resource_path;
bool RStream::initialized = false;

void RStream::Initialize(const string &resource_path_)
{
    if (initialized) throw RStreamError("N/A", "Resource Loader Initialized Twice");
    resource_path = resource_path_;
    if (resource_path.length()>0 && *(resource_path.end()-1) != '/') {
        resource_path += '/';
    }
    initialized = true;
}

RStream::RStream(const string &resource_name)
    : istream(&my_filebuf)
{
    // Open the resource as a (unix mode) file for now.
    bool success = my_filebuf.open((resource_path + resource_name).c_str(), ios_base::in | ios_base::binary);
    my_filebuf.pubsetbuf(buffer, BUFSIZE);
    if (!success) throw RStreamError(resource_name, "could not open file");
}

RStream::~RStream()
{
    // make sure the filebuf gets closed on exit.
    my_filebuf.close();
}

