/*
 * round.hpp
 *
 * Rounds a float to the nearest integer.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include <cmath>
using namespace std;

int Round(float x)
{
    float frac;
    float ipart;

    frac = modf(x, &ipart);

    if (x < 0) {
        if (frac <= -0.5f) return int(x) - 1;
        else return int(x);
    } else {
        if (frac >= 0.5f) return int(x) + 1;
        else return int(x);
    }
}
