/*
 * rng.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "rng.hpp"

#include <cstdlib>
#include <ctime>
using namespace std;

// define g_rng
MersenneRNG g_rng;

void StandardRNG::seedFromTime()
{
    srand(time(0));
}

float StandardRNG::getU01()
{
    return float(rand()) / (float(RAND_MAX)+1);
}


void MersenneRNG::seedFromTime()
{
    boost::lock_guard<boost::mutex> lock(mutex);
    gen.seed(time(0));
}

float MersenneRNG::getU01()
{
    boost::lock_guard<boost::mutex> lock(mutex);
    const gen_type::result_type val = gen();
    const gen_type::result_type min = gen.min();
    const gen_type::result_type max = gen.max();
    return float(val - min) / (float(max - min) + 1.0f);
}
