/*
 * my_exceptions.hpp
 *
 * An attempt to standardize some of the exceptions used in the game
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MY_EXCEPTIONS_HPP
#define MY_EXCEPTIONS_HPP

#include "exception_base.hpp"

#include <string>
using namespace std;

// error during game initialization (eg: sdl font could not be loaded)
class InitError : public ExceptionBase {
public:
    InitError(const string &s) : ExceptionBase(s) { }
};

// failed to load graphic (or other resource!)
class GraphicLoadFailed : public ExceptionBase {
public:
    GraphicLoadFailed(const string &s) : ExceptionBase(s) { }
};

// something unexpected happened (throwing this indicates a bug or not-yet-implemented
// feature)

class UnexpectedError : public ExceptionBase {
public:
    UnexpectedError(const string &s) : ExceptionBase(s) { }
};


#endif
