/*
 * misc.hpp
 * Header included by all .cpp files.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MISC_HPP
#define MISC_HPP

#ifdef NDEBUG

// Disable assertions
#define ASSERT(x)

#elif defined(BOOST_ENABLE_ASSERT_HANDLER)

// Use boost::assert
#include "boost/assert.hpp"
#define ASSERT(x) BOOST_ASSERT(x)

#else

// Use C standard assert command
#include <cassert>
using namespace std;
#define ASSERT(x) assert(x)

#endif

#endif

