/*
 * exception_base.hpp
 *
 * ExceptionBase: subclass of std::exception that defines what() for
 * you.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MISC_ERROR_HPP
#define MISC_ERROR_HPP

#include <exception>
#include <string>

class ExceptionBase : public std::exception {
public:
    explicit ExceptionBase(const std::string &s_) : s(s_) { }
    virtual ~ExceptionBase() throw() { }
    virtual const char *what() const throw() { return s.c_str(); }
private:
    std::string s;
};

#endif
