/*
 * config_map.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef CONFIG_MAP_HPP
#define CONFIG_MAP_HPP

#include "my_exceptions.hpp"
#include "kconfig_fwd.hpp"

#include <map>
#include <string>

class BadConfig : public ExceptionBase {
public:
    explicit BadConfig(const std::string &key) : ExceptionBase("Config key " + key + " not found") { }
};
    
class ConfigMap {
public:
    void setInt(const std::string &key, int val) { ints.insert(std::make_pair(key, val)); }
    void setString(const std::string &key, const std::string &val) { strings.insert(std::make_pair(key, val)); }

    int getInt(const std::string &key) const {
        std::map<std::string, int>::const_iterator it = ints.find(key);
        if (it == ints.end()) throw BadConfig(key);
        else return it->second;
    }

    const std::string & getString(const std::string &key) const {
        std::map<std::string, std::string>::const_iterator it = strings.find(key);
        if (it == strings.end()) throw BadConfig(key);
        else return it->second;
    }

private:
    std::map<std::string, int> ints;
    std::map<std::string, std::string> strings;
};

// load a config map from a KFile table.
void PopConfigMap(KConfig::KFile &kfile, ConfigMap &cfg_map);

#endif
