/*
 * config_map.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "config_map.hpp"
#include "kfile.hpp"

void PopConfigMap(KConfig::KFile &kf, ConfigMap &cmap)
{
    const KConfig::Value * tbl = kf.getTop();

    try {
        if (tbl) {
            string key = "";
            while (1) {
                key = tbl->getTableNext(key);
                if (key.empty()) break;   // reached the end
                const KConfig::Value &val = tbl->getTable(key);

                if (val.isInt()) {
                    cmap.setInt(key, val.getInt());
                } else if (val.isString()) {
                    cmap.setString(key, val.getString());
                } else {
                    kf.error("incorrect data type in config table");
                }
            }
        }
    } catch (...) {
        kf.pop();
        throw;
    }
    kf.pop();
}
