/*
 * x_centre.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "x_centre.hpp"

void XCentre(Coercri::GfxContext &gc, const Coercri::Font &font, int y, const std::string &text)
{
    const int w = font.getTextWidth(text);
    const int x = (gc.getWidth() - w) / 2;

    // This routine always draws in white with antialiasing
    gc.drawText(x, y, font, text, Coercri::Color(255,255,255), true);
}
