/*
 * title_block.hpp
 *
 * Widget for title boxes, as drawn above a ListBox.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TITLE_BLOCK_HPP
#define TITLE_BLOCK_HPP

#include "guichan.hpp"

#include <string>
#include <vector>
using namespace std;

class TitleBlock : public gcn::Widget {
public:
    // ctor copies the two input vectors.
    explicit TitleBlock(const std::vector<std::string> &titles_, const std::vector<int> &widths_);

    void draw(gcn::Graphics *graphics);
    void drawFrame(gcn::Graphics *) { }
    
private:
    std::vector<std::string> titles;
    std::vector<int> widths;
};

#endif
