/*
 * title_block.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "title_block.hpp"

#include <numeric>

TitleBlock::TitleBlock(const std::vector<std::string> &t, const std::vector<int> &w)
    : titles(t), widths(w)
{
    setSize(std::accumulate(widths.begin(), widths.end(), 0), getFont()->getHeight() + 4);
}

namespace {
    void DrawTitleBox(gcn::Graphics *gfx, int x1, int y1, int x2, int y2)
    {
        gfx->setColor(gcn::Color(255, 255, 255));
        gfx->drawLine(x1, y1, x2-2, y1);
        gfx->drawLine(x1, y1, x1, y2-1);
        gfx->setColor(gcn::Color(0,0,0));
        gfx->drawLine(x2-1, y1, x2-1, y2-1);
        gfx->drawLine(x1+1, y2-1, x2-1, y2-1);
        gfx->setColor(gcn::Color(180, 180, 180));
        gfx->fillRectangle(gcn::Rectangle(x1+1, y1+1, x2-x1-2, y2-y1-2));
    }
}

void TitleBlock::draw(gcn::Graphics *graphics)
{
    graphics->setFont(getFont());
    int x = 0;
    for (int i = 0; i < int(titles.size()); ++i) {
        DrawTitleBox(graphics, x, 0, x + widths[i], getHeight());
        graphics->drawText(titles[i], x + 2, 2, gcn::Graphics::LEFT);
        x += widths[i];
    }
}
