/*
 * text_formatter.hpp
 *
 * Prints out lines of text. Wraps long lines, and also handles "rich text"
 * directives if asked to.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TEXT_FORMATTER_HPP
#define TEXT_FORMATTER_HPP

#include <string>

struct Printer {
    virtual int getTextWidth(const std::string &text) = 0;
    virtual int getTextHeight() = 0;
    virtual void printLine(const std::string &text, int y, bool do_centre) = 0;
};

class TextFormatter {
public:
    TextFormatter(Printer &p, int width, bool rich);

    // print a string, breaking into separate lines if necessary
    // returns the total height printed.
    int printString(const std::string &msg);

private:
    Printer &printer;
    int max_line_width;
    bool is_rich;
    bool do_centre; // false initially; turned on by %c directives.
    int y;
};

#endif
