/*
 * tab_font.hpp
 * 
 * Modifies a Font to draw with tab stops. Used to implement a sort of
 * poor man's multi column list box (Guichan doesn't include a multi
 * column list widget).
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#ifndef TAB_FONT_HPP
#define TAB_FONT_HPP

#include "gfx/font.hpp"

#include "boost/shared_ptr.hpp"

#include <vector>

class TabFont : public Coercri::Font {
public:
    TabFont(boost::shared_ptr<Coercri::Font> base_font, const std::vector<int> & field_widths_);
    virtual void drawText(Coercri::GfxContext &dest, int x, int y, const std::string &text,
                          Coercri::Color col, bool antialias) const;
    virtual int getTextHeight() const { return base_font->getTextHeight(); }
    virtual void getTextSize(const std::string &text, int &w, int &h) const;
private:
    boost::shared_ptr<Coercri::Font> base_font;
    std::vector<int> field_widths;
};

#endif
