/*
 * tab_font.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "tab_font.hpp"

TabFont::TabFont(boost::shared_ptr<Coercri::Font> b, const std::vector<int> &t)
    : base_font(b), field_widths(t)
{ }

namespace {
    // precondition: !s.empty()
    std::string GetNext(std::string &s)
    {
        std::string result;
        size_t pos = s.find('\t');
        if (pos == std::string::npos) {
            result = s;
            s.clear();
        } else {
            result = s.substr(0, pos);
            s = s.substr(pos+1);
        }
        return result;
    }

    void ClipString(std::string &s, const Coercri::Font &font, int max_width)
    {
        while (font.getTextWidth(s) > max_width && !s.empty()) {
            s.erase(s.length()-1);
        }
    }
}

void TabFont::drawText(Coercri::GfxContext &dest, int x, int y, const std::string &text,
                       Coercri::Color col, bool antialias) const
{
    int i = 0;
    std::string s = text;
    while (!s.empty() && i < field_widths.size()) {
        std::string to_draw = GetNext(s);
        ClipString(to_draw, *base_font, field_widths[i]);
        base_font->drawText(dest, x, y, to_draw, col, antialias);
        x += field_widths[i];
        ++i;
    }
}

void TabFont::getTextSize(const std::string &text, int &w, int &h) const
{
    // NOTE: we assume text height is equal for all fields
    // (only height for the final field will be returned).
    int i = 0, x = 0;
    std::string s = text;
    std::string last_str;
    while (!s.empty() && i < field_widths.size()) {
        std::string to_draw = GetNext(s);
        ClipString(to_draw, *base_font, field_widths[i]);
        int ww;
        base_font->getTextSize(to_draw, ww, h);
        w = x + ww;
        x += field_widths[i];
        ++i;
    }
}
