/*
 * sound_manager.hpp
 *
 * Keeps track of all loaded sounds
 * 
 * NOTE: This class is not protected by locks so it should only be
 * accessed by one thread at a time. Currently the only access from
 * outside the main thread comes from the "loader" thread in
 * GameManager. (The game does not start until this thread has
 * exited so this should be OK.)
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SOUND_MANAGER_HPP
#define SOUND_MANAGER_HPP

// coercri
#include "sound/sound_driver.hpp"

#include "boost/shared_ptr.hpp"

#include <map>
#include <string>

class Sound;

class SoundManager {
public:
    explicit SoundManager(boost::shared_ptr<Coercri::SoundDriver> d) : sound_driver(d) { }
    
    void loadSound(const Sound &sound);
    void playSound(const Sound &sound, int frequency);
    void clear();  // unloads all sounds.
    
private:
    boost::shared_ptr<Coercri::SoundDriver> sound_driver;
    std::map<const Sound*, boost::shared_ptr<Coercri::Sound> > sound_map;
};

#endif
