/*
 * sound_manager.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "rstream.hpp"
#include "sound.hpp"
#include "sound_manager.hpp"

void SoundManager::loadSound(const Sound &sound)
{
    if (!sound_driver) return;

    if (sound_map.find(&sound) == sound_map.end()) {
        boost::shared_ptr<RStream> str(new RStream(sound.getFilename()));
        sound_map.insert(make_pair(&sound, sound_driver->loadSound(str)));
    }
}

void SoundManager::playSound(const Sound &sound, int frequency)
{
    if (!sound_driver) return;
    
    map<const Sound *, boost::shared_ptr<Coercri::Sound> >::iterator it = sound_map.find(&sound);
    if (it == sound_map.end()) {
        loadSound(sound);
        it = sound_map.find(&sound);
        ASSERT(it != sound_map.end());
    }
    sound_driver->playSound(it->second, frequency);
}

void SoundManager::clear()
{
    sound_map.clear();
}
