/*
 * skull_renderer.hpp
 *
 * Draws the columns of skulls, representing how many times you have died.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SKULL_RENDERER_HPP
#define SKULL_RENDERER_HPP

#include "gfx/gfx_context.hpp" // from coercri

#include <vector>
using namespace std;

class SkullRenderer {
public:
    //
    // setup
    //
    
    SkullRenderer() { }
    
    // The skull graphics should be added in ascending order. The first has one skull
    // on it, the second has two skulls etc.
    void addGraphic(const Graphic *);

    // Pixel positions for the rows and columns. A graphic is drawn at (r,c) for each r and
    // each c, until all skulls have been drawn.
    void addColumn(int c);
    void addRow(int r);

    
    //
    // drawing
    //

    // draw (clip rectangle should be unset, will be taken care of by this func)
    void draw(Coercri::GfxContext &gc, GfxManager &gm, int no_skulls, int left, int top, float scale) const;
   
private:
    vector<const Graphic *> gfx;
    vector<int> rows, columns;
};

#endif
