/*
 * skull_renderer.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "gfx_manager.hpp"
#include "round.hpp"
#include "skull_renderer.hpp"

void SkullRenderer::addGraphic(const Graphic *g)
{
    gfx.push_back(g);
}

void SkullRenderer::addColumn(int c)
{
    columns.push_back(c);
}

void SkullRenderer::addRow(int r)
{
    rows.push_back(r);
}

void SkullRenderer::draw(Coercri::GfxContext &gc, GfxManager &gm, int nsk, int left, int top, float scale_factor) const
{
    int r = 0;
    int c = 0;
    while (nsk > 0) {
        const int x = Round(float(columns[c])*scale_factor) + left;
        const int y = Round(float(rows[r])*scale_factor) + top;
        const int n = min(nsk, int(gfx.size()));

        int w, h;
        gm.getGraphicSize(*gfx[n-1], w, h);
        w = Round(float(w) * scale_factor);
        h = Round(float(h) * scale_factor);

        gm.drawTransformedGraphic(gc, x, y, *gfx[n-1], w, h);
        nsk -= n;
        ++r;
        if (r >= rows.size()) {
            r = 0;
            ++c;
            if (c >= columns.size()) {
                // maximum number of skulls has been reached
                break;
            }
        }
    }
}
