/*
 * screen.hpp
 *
 * Base class for game screens (menu screen, in game screen, etc)
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SCREEN_HPP
#define SCREEN_HPP

// coercri
#include "gfx/window.hpp"

#include "guichan.hpp"

#include "boost/shared_ptr.hpp"

class KnightsApp;

class Screen {
public:
    // This method starts the screen
    // Returns true if it wants gui enabled, or false if disabled.
    virtual bool start(KnightsApp &app, boost::shared_ptr<Coercri::Window> window, gcn::Gui &gui) = 0;

    // The destructor should stop the screen (or do nothing if start() wasn't called)
    virtual ~Screen() { }
    
    // getUpdateInterval: How often we want periodic updates (or 0 if we don't need this).
    // update() will be called at MOST every getUpdateInterval(), but can be called less frequently if CPU time is limited.
    // NOTE: update() ceases to be called after a successful requestScreenChange().
    virtual unsigned int getUpdateInterval() { return 0; }
    virtual void update() { }

    // draw: Draw the screen
    // NOTE: Main loop will call cg_listener->draw() so this is only needed for non-Guichan drawing.
    virtual void draw(Coercri::GfxContext &gc) { }

    virtual unsigned int getMaxLag() { return getUpdateInterval() * 5; }
};

#endif
