/*
 * potion_renderer.hpp
 *
 * This draws the potion bottle, showing Knight's health and current magic.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef POTION_RENDERER_HPP
#define POTION_RENDERER_HPP

#include "colour_change.hpp"
#include "potion_magic.hpp"

#include "gfx/gfx_context.hpp"

#include <vector>
using namespace std;

class ConfigMap;
class GfxManager;
class Graphic;

class PotionRenderer {
public:
    //
    // setup
    //
    explicit PotionRenderer(const ConfigMap &cfg);
    
    // Graphics, to be added in order of increasing health
    // (first for 0 health, second for 1 hitpoint, 3rd for 2 hitpoints etc)
    void addGraphic(const Graphic *);

    // Colours, to be added in order of PotionMagics.
    void addColour(Colour col);

    //
    // drawing
    // (clip rectangle should be unset, will be taken care of by this func)
    //
    void draw(int time, Coercri::GfxContext &, GfxManager &, int health, PotionMagic magic, bool poison_immunity,
              int left, int top, float scale) const;
    
private:
    const ConfigMap &config_map;
    bool def_set;
    Colour def_col;
    vector<const Graphic *> gfx;
    vector<ColourChange> colours;
};

#endif
