/*
 * options.hpp
 *
 * Storage for game options
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef OPTIONS_HPP
#define OPTIONS_HPP

#include "gfx/key_code.hpp"  // from coercri

#include <iostream>

class ConfigMap;

class Options {
public:
    Options();  // Sets the defaults

    Coercri::KeyCode ctrls[2][6];  // 2 players, and in order up/down/left/right/action/suicide.
    bool use_scale2x;
    bool fullscreen;

    // added in version 2 of options file (version 009 of Knights)
    bool allow_non_integer_scaling;
    int window_width;
    int window_height;
};

Options LoadOptions(std::istream &);
void SaveOptions(const Options &, std::ostream &);

#endif
