/*
 * options.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "config_map.hpp"
#include "options.hpp"

#include <cstring>

Options::Options()
{
    ctrls[0][0] = Coercri::KC_W;
    ctrls[0][1] = Coercri::KC_S;
    ctrls[0][2] = Coercri::KC_A;
    ctrls[0][3] = Coercri::KC_D;
    ctrls[0][4] = Coercri::KC_Q;
    ctrls[0][5] = Coercri::KC_F1;

    ctrls[1][0] = Coercri::KC_UP;
    ctrls[1][1] = Coercri::KC_DOWN;
    ctrls[1][2] = Coercri::KC_LEFT;
    ctrls[1][3] = Coercri::KC_RIGHT;
    ctrls[1][4] = Coercri::KC_RIGHT_CONTROL;
    ctrls[1][5] = Coercri::KC_F12;

    use_scale2x = true;
    fullscreen = true;

    allow_non_integer_scaling = false;
    window_width = 950;
    window_height = 710;
}

Options LoadOptions(std::istream &str)
{
    Options o;

    char buf[8] = {0};
    str.getline(buf, 6);

    const bool version1 = (std::strcmp(buf, "KOPT1") == 0);
    const bool version2 = (std::strcmp(buf, "KOPT2") == 0);
    
    if (!version1 && !version2) return Options();
    
    for (int i = 0; i < 2; ++i) {
        for (int j = 0; j < 6; ++j) {
            int x;
            str >> x;
            o.ctrls[i][j] = Coercri::KeyCode(x);
        }
    }
    str >> o.use_scale2x;
    str >> o.fullscreen;

    if (version2) {
        str >> o.allow_non_integer_scaling;
        str >> o.window_width >> o.window_height;
    }
    
    if (!str) return Options();  // In case of load failure, return default options
    else return o;
}

void SaveOptions(const Options &o, std::ostream &str)
{
    str << "KOPT2\n";
    for (int i = 0; i < 2; ++i) {
        for (int j = 0; j < 6; ++j) {
            str << o.ctrls[i][j] << " ";
        }
        str << "\n";
    }
    str << o.use_scale2x << "\n";
    str << o.fullscreen << "\n";
    str << o.allow_non_integer_scaling << "\n";
    str << o.window_width << " " << o.window_height << "\n";
}
