/*
 * menu_screen.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MENU_SCREEN_HPP
#define MENU_SCREEN_HPP

#include "screen.hpp"

#include <vector>
using namespace std;

class KnightsClient;
class MenuScreenImpl;

class MenuScreen : public Screen {
public:
    explicit MenuScreen(boost::shared_ptr<KnightsClient> knights_client, bool extended, bool show_obs);
    virtual bool start(KnightsApp &app, boost::shared_ptr<Coercri::Window> win, gcn::Gui &gui);
    virtual unsigned int getUpdateInterval() { return 50; }
    virtual void update();
    
private:
    boost::shared_ptr<MenuScreenImpl> pimpl;
    boost::shared_ptr<KnightsClient> knights_client;
    bool extended, show_obs;
};

#endif
