/*
 * make_scroll_area.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "make_scroll_area.hpp"

std::auto_ptr<gcn::ScrollArea> MakeScrollArea(gcn::Widget &content, int width, int height, int scrollbar_width)
{
    std::auto_ptr<gcn::ScrollArea> scroll_area(new gcn::ScrollArea);
    scroll_area->setContent(&content);
    scroll_area->setBackgroundColor(gcn::Color(255,255,255));
    scroll_area->setOpaque(true);
    scroll_area->setSize(width, height);
    scroll_area->setScrollbarWidth(scrollbar_width);
    scroll_area->setFrameSize(1);

    return scroll_area;
}
