/*
 * local_status_display.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef LOCAL_STATUS_DISPLAY_HPP
#define LOCAL_STATUS_DISPLAY_HPP

#include "map_support.hpp"
#include "status_display.hpp"

#include "gfx/gfx_context.hpp" // coercri

#include <map>

class GfxManager;
class Graphic;
class LocalMiniMap;
class PotionRenderer;
class SkullRenderer;

class LocalStatusDisplay : public StatusDisplay {
public:

    //
    // functions specific to this class
    //

    LocalStatusDisplay(const ConfigMap &cfg,
                       const PotionRenderer *potion_renderer_,
                       const SkullRenderer *skull_renderer_,
                       const Graphic *menu_gfx_centre_,
                       const Graphic *menu_gfx_empty_,
                       const Graphic *menu_gfx_highlight_);
    void draw(Coercri::GfxContext &gc, GfxManager &gm, 
              int time, float scale,
              int x, int y,
              bool show_potion_bottle,
              const LocalMiniMap &mini_map);
    void getSize(float scale, int &width, int &height) const;
    void setMenuOpen(bool m) { menu_open = m; }
    bool isMenuOpen() const { return menu_open; }
    void clearMenuGraphics();
    void setMenuGraphic(MapDirection d, const Graphic *g);
    void setMenuHighlight(MapDirection d) { menu_highlight = true; menu_highlight_dir = d; }
    void clearMenuHighlight() { menu_highlight = false; }

    // get quest info
    const std::string & getQuestMsg() const { return quest_msg; }
    const std::vector<StatusDisplay::QuestIconInfo> & getQuestIcons() const { return quest_icons; }
    bool needGuiUpdate() { const bool result = need_gui_update; need_gui_update = false; return result; }
    
    //
    // functions from StatusDisplay
    //

    void setBackpack(int slot, const Graphic *gfx, const Graphic *overdraw,
                     int no_carried, int no_max);
    void addSkull();
    void setHealth(int h);
    void setPotionMagic(PotionMagic pm, bool poison_immunity);
    void setQuestMessage(const std::string &msg) { quest_msg = msg; }
    void setQuestIcons(const std::vector<StatusDisplay::QuestIconInfo> &);
    
private:
    const ConfigMap &config_map;

    // cached config variables
    const int ref_inventory_left, ref_inventory_top, ref_inventory_width, ref_inventory_height;
    const int num_inventory_slots, ref_inventory_spacing, ref_inventory_gem_height;
    const int ref_mini_map_left, ref_mini_map_top, ref_mini_map_width, ref_mini_map_height;
    const int ref_skulls_left, ref_skulls_top;
    const int ref_potion_left, ref_potion_top;

    // skulls and potion bottle
    const SkullRenderer *skull_renderer;
    const PotionRenderer *potion_renderer;
    int nskulls;
    int health;
    PotionMagic magic;
    bool poison_immun;

    // backpack
    struct BackpackEntry {
        const Graphic *gfx;
        const Graphic *overdraw;
        int no_carried;
        int no_max;
    };
    std::map<int, BackpackEntry> backpack;

    // menu
    const Graphic * menu_gfx_centre;    // 'arrows' graphic
    const Graphic * menu_gfx_empty;     // 'empty square' graphic
    const Graphic * menu_gfx_highlight; // 'highlight' graphic
    const Graphic * menu_gfx[4];        // graphics for the 4 directions
    bool menu_open;
    bool menu_highlight;
    MapDirection menu_highlight_dir;

    // quest status info from server
    std::string quest_msg;
    std::vector<StatusDisplay::QuestIconInfo> quest_icons;
    bool need_gui_update;
};

#endif

    
