/*
 * local_mini_map.hpp
 *
 * Implementation of MiniMap for on-screen drawing.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef LOCAL_MINI_MAP_HPP
#define LOCAL_MINI_MAP_HPP

#include "mini_map.hpp"

#include "gfx/gfx_context.hpp"  // coercri

#include <map>
#include <vector>

class ConfigMap;

class LocalMiniMap : public MiniMap {
public:

    //
    // functions specific to this class
    //

    explicit LocalMiniMap(const ConfigMap &cfg) : config_map(cfg), width(0), height(0) { }
    void draw(Coercri::GfxContext &gc, int left, int top, int width, int height, int time) const;
    int getWidth() const { return width; }
    int getHeight() const { return height; }
    
    //
    // functions overridden from MiniMap
    //

    void setSize(int width, int height);
    void setColour(int x, int y, MiniMapColour col);
    void wipeMap();
    void mapKnightLocation(int n, int x, int y);
    void mapItemLocation(int x, int y, bool on);

private:
    void setHighlight(int x, int y, int id);
    
    struct Highlighter {
        Highlighter(const LocalMiniMap &m, int t, const ConfigMap &cfg);  // sets highlights to appropriate colour
        ~Highlighter();  // resets highlights to their original colours.
        const LocalMiniMap &mini_map;
    };

    const ConfigMap &config_map;
    int width, height;
    mutable std::vector<MiniMapColour> data;   // must be mutable for Highlighter to work properly.
    struct Highlight {
        int x, y;
        mutable MiniMapColour old_colour;
    };
    std::map<int, Highlight> highlights;
};

#endif
