/*
 * lobby_screen.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#ifndef LOBBY_SCREEN_HPP
#define LOBBY_SCREEN_HPP

#include "screen.hpp"

class LobbyScreenImpl;

class LobbyScreen : public Screen {
public:
    // it's expected that both the KnightsClient and the GameManager have been created
    // before we go into the LobbyScreen.
    // also, we should already have sent the CLIENT_SET_PLAYER_NAME msg if applicable.
    explicit LobbyScreen(boost::shared_ptr<KnightsClient> cli, const std::string &svr_name);
    virtual bool start(KnightsApp &knights_app, boost::shared_ptr<Coercri::Window> window, gcn::Gui &gui);
    virtual void update();
    virtual unsigned int getUpdateInterval();
    
private:
    boost::shared_ptr<LobbyScreenImpl> pimpl;
};

#endif
