/*
 * loading_screen.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef LOADING_SCREEN_HPP
#define LOADING_SCREEN_HPP

#include "kconfig_fwd.hpp"
#include "screen.hpp"

#include "boost/thread.hpp"
#include <string>

class KnightsServer;

class LoadingScreen : public Screen {
public:
    explicit LoadingScreen(int port);   // set port to -1 for local game
    virtual ~LoadingScreen();
    virtual bool start(KnightsApp &knights_app, boost::shared_ptr<Coercri::Window>, gcn::Gui &);
    virtual unsigned int getUpdateInterval() { return 50; }
    virtual void update();
    virtual void draw(Coercri::GfxContext &gc);

private:
    struct Loader {
        explicit Loader(KnightsApp &knights_app);
        void operator()();
        
        KnightsApp &knights_app;
        std::string error_msg;
        std::auto_ptr<KConfig::KConfigError> kconfig_error;
    };

    KnightsApp *knights_app;
    int server_port;
    boost::shared_ptr<Loader> loader;
    boost::thread loader_thread;
};

#endif
