/*
 * load_font.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#ifndef LOAD_FONT_HPP
#define LOAD_FONT_HPP

#include "gfx/font.hpp"        // coercri
#include "gfx/ttf_loader.hpp"  // coercri
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

boost::shared_ptr<Coercri::Font> LoadFont(Coercri::TTFLoader &loader,
                                          const std::vector<std::string> &ttf_font_names,
                                          const std::vector<std::string> &bmp_font_names, int size);

#endif
