/*
 * load_font.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#include "misc.hpp"

#include "load_font.hpp"
#include "my_exceptions.hpp"  // misc
#include "rstream.hpp"        // rstream

#include "gfx/bitmap_font.hpp"      // coercri
#include "gfx/load_bmp.hpp"         // coercri
#include "gfx/load_system_ttf.hpp"  // coercri

boost::shared_ptr<Coercri::Font> LoadFont(Coercri::TTFLoader &ttf_loader,
                                          const vector<string> &ttf_font_names,
                                          const vector<string> &bitmap_font_names, int size)
{
    try {
        if (!ttf_font_names.empty()) {
            return Coercri::LoadSystemTTF(ttf_loader, ttf_font_names, size);
        }
    } catch (...) { }
    
    for (vector<string>::const_iterator it = bitmap_font_names.begin(); it != bitmap_font_names.end(); ++it) {
        try {
            RStream str(*it);
            boost::shared_ptr<Coercri::PixelArray> pix = Coercri::LoadBMP(str);
            boost::shared_ptr<Coercri::Font> result(new Coercri::BitmapFont(pix));
            return result;
        } catch (...) { }
    }

    throw GraphicLoadFailed("Could not load font! Check fonts.txt");
}
