/*
 * keyboard_controller.hpp
 *
 * KeyboardController: Controller that reads input from the Keyboard
 * Keys to use must be configured in the constructor.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef KEYBOARD_CONTROLLER_HPP
#define KEYBOARD_CONTROLLER_HPP

#include "controller.hpp"

// coercri
#include "gfx/key_code.hpp"
#include "gfx/window.hpp"

#include "boost/scoped_ptr.hpp"

class KeyboardListener;

class KeyboardController : public Controller {
public:
    KeyboardController(Coercri::KeyCode up_key_, Coercri::KeyCode right_key_, Coercri::KeyCode down_key_,
                       Coercri::KeyCode left_key_, Coercri::KeyCode fire_key_, Coercri::KeyCode suicide_key_,
                       boost::shared_ptr<Coercri::Window> w);
    virtual ~KeyboardController();
    
    virtual void get(MapDirection &dir, bool &centred, bool &fire_held,
                     bool &suicide_held) const;

    virtual std::vector<Coercri::KeyCode> getReservedKeys() const;
    
private:
    friend class KeyboardListener;
    boost::scoped_ptr<KeyboardListener> kbd_listener;
    boost::shared_ptr<Coercri::Window> win;
    Coercri::KeyCode up_key, right_key, down_key, left_key, fire_key, suicide_key;
    bool up, right, down, left, fire, suicide;
};

#endif
