/*
 * keyboard_controller.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "keyboard_controller.hpp"

// coercri
#include "gfx/window_listener.hpp"

class KeyboardListener : public Coercri::WindowListener {
public:
    explicit KeyboardListener(KeyboardController &c) : ctrlr(c) { }
    virtual void onKey(Coercri::KeyEvent ke, Coercri::KeyCode kc, int character, int modifiers);

private:
    KeyboardController &ctrlr;
};

KeyboardController::KeyboardController(Coercri::KeyCode u, Coercri::KeyCode r, Coercri::KeyCode d,
                                       Coercri::KeyCode l, Coercri::KeyCode f, Coercri::KeyCode s,
                                       boost::shared_ptr<Coercri::Window> w)
    : kbd_listener(new KeyboardListener(*this)), win(w),
      up_key(u), right_key(r), down_key(d), left_key(l), fire_key(f), suicide_key(s),
      up(false), right(false), down(false), left(false), fire(false), suicide(false)
{
    win->addWindowListener(kbd_listener.get());
}

KeyboardController::~KeyboardController()
{
    win->rmWindowListener(kbd_listener.get());
}

void KeyboardController::get(MapDirection &dir, bool &centred, bool &fire_held,
                             bool &suicide_held) const
{
    fire_held = fire;
    suicide_held = suicide;
    centred = !up && !right && !down && !left;
    if (!centred) {
        if (up) dir = D_NORTH;
        else if (right) dir = D_EAST;
        else if (down) dir = D_SOUTH;
        else dir = D_WEST;
    }
}

std::vector<Coercri::KeyCode> KeyboardController::getReservedKeys() const
{
    std::vector<Coercri::KeyCode> result;
    result.push_back(up_key);
    result.push_back(right_key);
    result.push_back(down_key);
    result.push_back(left_key);
    result.push_back(fire_key);
    result.push_back(suicide_key);
    return result;
}

void KeyboardListener::onKey(Coercri::KeyEvent ke, Coercri::KeyCode kc, int character, int modifiers)
{
    if (ke == Coercri::KE_AUTO_REPEAT) return;  // we are not interested in keyboard repeat here.

    const bool p = ke == Coercri::KE_PRESSED;

    if (kc == ctrlr.up_key) { ctrlr.up = p; }
    else if (kc == ctrlr.right_key) { ctrlr.right = p; }
    else if (kc == ctrlr.down_key) { ctrlr.down = p; }
    else if (kc == ctrlr.left_key) { ctrlr.left = p; }
    else if (kc == ctrlr.fire_key) { ctrlr.fire = p; }
    else if (kc == ctrlr.suicide_key) { ctrlr.suicide = p; }
}
