/*
 * in_game_screen.hpp
 *
 * InGameScreen
 * --- runs the game
 * Goes back to MenuScreen when done
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef IN_GAME_SCREEN_HPP
#define IN_GAME_SCREEN_HPP

#include "screen.hpp"

#include "gfx/window_listener.hpp"  // coercri

#include "boost/scoped_ptr.hpp"

#include <string>
#include <vector>

class ClientConfig;
class Graphic;
class KnightsClient;
class LocalDisplay;
class UserControl;

class GuiPanel2;

class InGameScreen : public Screen, public Coercri::WindowListener {
public:
    InGameScreen(KnightsApp &ka, boost::shared_ptr<KnightsClient> knights_client, 
                 boost::shared_ptr<const ClientConfig> config, int nplayers_);
    virtual bool start(KnightsApp &, boost::shared_ptr<Coercri::Window> win, gcn::Gui &gui);
    virtual ~InGameScreen();
    virtual unsigned int getUpdateInterval();
    virtual void update();
    virtual void draw(Coercri::GfxContext &gc);

    virtual void onMouseMove(int new_x, int new_y);
    virtual void onMouseDown(int x, int y, Coercri::MouseButton m);
    virtual void onKey(Coercri::KeyEvent ke, Coercri::KeyCode kc, int character, int modifiers);
    virtual void onActivate();
    virtual void onDeactivate();
    
private:
    void setupDisplay();

private:
    bool pause_mode;
    bool window_minimized;
    bool auto_mouse;
    int nplayers;
    int prev_update_time;

    boost::shared_ptr<LocalDisplay> display;

    enum GameStage { LOADING_STAGE, INGAME_STAGE };
    GameStage stage;

    boost::shared_ptr<Coercri::Window> window;

    KnightsApp &knights_app;
    boost::shared_ptr<KnightsClient> knights_client;
    boost::shared_ptr<const ClientConfig> client_config;

    boost::scoped_ptr<gcn::Container> container;
};

#endif
