/*
 * gui_text_wrap.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef GUI_TEXT_WRAP_HPP
#define GUI_TEXT_WRAP_HPP

#include "guichan.hpp"

class GuiTextWrap : public gcn::Widget, public gcn::MouseListener {
public:
    GuiTextWrap();
    
    void setText(const std::string &t) { text = t; }
    const std::string & getText() const { return text; }

    void adjustHeight();
    
    // whether to draw the background
    void setOpaque(bool o) { opaque = o; }
    bool isOpaque() const { return opaque; }

    // whether to centre each line of text
    void setCentred(bool c) { centred = c; }
    bool isCentred() const { return centred; }

    // whether to interpret %c or %l "rich text" sequences
    void setRich(bool r) { rich = r; }
    bool isRich() const { return rich; }
    
    virtual void draw(gcn::Graphics *graphics);
    virtual void mouseReleased(gcn::MouseEvent &mouseEvent);

private:
    std::string text;
    bool opaque;
    bool centred;
    bool rich;
};

#endif
