/*
 * gui_text_wrap.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "gui_text_wrap.hpp"
#include "text_formatter.hpp"

#include <cctype>

namespace {
    const int pad = 2;
    
    struct ActualPrinter : Printer {
        ActualPrinter(int w, gcn::Font &f, gcn::Graphics *g) : width(w), font(f), graphics(g) { }

        int getTextWidth(const std::string &t) { return font.getWidth(t) + 2*pad; }
        int getTextHeight() { return font.getHeight(); }

        void printLine(const std::string &text, int y, bool do_centre)
        {
            if (graphics) {
                if (do_centre) {
                    graphics->drawText(text, width/2, y, gcn::Graphics::CENTER);
                } else {
                    graphics->drawText(text, pad, y);
                }
            }
        }

        int width;
        gcn::Font &font;
        gcn::Graphics *graphics;
    };
}

GuiTextWrap::GuiTextWrap()
    : opaque(false), centred(false), rich(false)
{
    addMouseListener(this);
}

void GuiTextWrap::draw(gcn::Graphics *graphics)
{
    if (isOpaque()) {
        // Clear the background first.
        graphics->setColor(getBackgroundColor());
        graphics->fillRectangle(gcn::Rectangle(0, 0, getWidth(), getHeight()));
    }
    
    graphics->setFont(getFont());

    ActualPrinter p(getWidth(), *getFont(), graphics);
    TextFormatter formatter(p, getWidth(), rich);
    formatter.printString(text);
}

void GuiTextWrap::adjustHeight()
{
    ActualPrinter p(getWidth(), *getFont(), 0);
    TextFormatter formatter(p, getWidth(), rich);
    setHeight(formatter.printString(text));
}

void GuiTextWrap::mouseReleased(gcn::MouseEvent &mouseEvent)
{
    distributeActionEvent();
}
