/*
 * gui_simple_container.hpp
 *
 * Container that contains only a single child widget.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef GUI_SIMPLE_CONTAINER_HPP
#define GUI_SIMPLE_CONTAINER_HPP

#include "guichan.hpp"

class GuiSimpleContainer : public gcn::BasicContainer, public gcn::WidgetListener {
public:
    explicit GuiSimpleContainer(gcn::Widget *c);

    void setChild(gcn::Widget *c);
    gcn::Widget * getChild();

    // NB: Subclasses should override void draw(gcn::Graphics *graphics). Should at least call drawChildren(graphics).
    // Subclasses may also override void widgetResized(const gcn::Event &event) (called when either this or child is resized).
};

#endif
