/*
 * gui_simple_container.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "gui_simple_container.hpp"

GuiSimpleContainer::GuiSimpleContainer(gcn::Widget *c)
{
    setChild(c);
    addWidgetListener(this);
}

void GuiSimpleContainer::setChild(gcn::Widget *c)
{
    if (!mWidgets.empty()) {
        mWidgets.front()->removeWidgetListener(this);
        clear();
    }
    if (c) {
        add(c);
        c->addWidgetListener(this);
        widgetResized(gcn::Event(this));  // Force any re-layout etc in the subclass
    }
}

gcn::Widget * GuiSimpleContainer::getChild()
{
    if (mWidgets.empty()) {
        return 0;
    } else {
        return mWidgets.front();
    }
}

