/*
 * gui_panel_2.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "gui_draw_box.hpp"
#include "gui_panel_2.hpp"

GuiPanel2::GuiPanel2(gcn::Widget *c)
    : GuiSimpleContainer(c)
{
    const int DEFAULT_BORDER = 3;
    
    if (c) {
        setSize(c->getWidth() + 2*DEFAULT_BORDER, c->getHeight() + 2*DEFAULT_BORDER);
        c->setPosition(DEFAULT_BORDER, DEFAULT_BORDER);
    }
}

void GuiPanel2::draw(gcn::Graphics *graphics)
{
    GuiDrawBox2(graphics, 0, 0, getWidth(), getHeight());    
    drawChildren(graphics);
}
