/*
 * gui_panel.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "gui_draw_box.hpp"
#include "gui_panel.hpp"

GuiPanel::GuiPanel(gcn::Widget *c)
    : GuiSimpleContainer(c)
{
    const int DEFAULT_BORDER = 3;
    
    if (c) {
        setSize(c->getWidth() + 2*DEFAULT_BORDER, c->getHeight() + 2*DEFAULT_BORDER);
        c->setPosition(DEFAULT_BORDER, DEFAULT_BORDER);
    }
}

void GuiPanel::draw(gcn::Graphics *graphics)
{
    const BoxCol PANEL_BOXCOL = { 240, 240, 240, 220, 220, 220 };
    
    GuiDrawBox(graphics, PANEL_BOXCOL, 0, 0, getWidth(), getHeight());
    drawChildren(graphics);
}
