/*
 * gui_centre.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "gui_centre.hpp"

GuiCentre::GuiCentre(gcn::Widget *c)
    : gcn::ScrollArea(c), resize_in_progress(false)
{
    setBackgroundColor(gcn::Color(0,0,0));
    setScrollbarWidth(15);
    widgetResized(gcn::Event(0));
    addWidgetListener(this);
}

void GuiCentre::widgetResized(const gcn::Event &event)
{
    if (resize_in_progress) return;
    resize_in_progress = true;

    gcn::Widget *contained = getContent();
    if (contained) {

        const int win_w = getWidth(), win_h = getHeight();
        const int con_w = contained->getWidth(), con_h = contained->getHeight();

        const bool naive_horiz_scroll = con_w > win_w;
        const bool naive_vert_scroll = con_h > win_h;
        const bool horiz_scroll = naive_horiz_scroll || (naive_vert_scroll && con_w > win_w - getScrollbarWidth());
        const bool vert_scroll = naive_vert_scroll || (naive_horiz_scroll && con_h > win_h - getScrollbarWidth());

        const int avail_w = vert_scroll ? win_w - getScrollbarWidth() : win_w;
        const int avail_h = horiz_scroll ? win_h - getScrollbarWidth() : win_h;

        const int x = std::max(0, (avail_w - con_w) / 2);
        const int y = std::max(0, (avail_h - con_h) / 2);
        
        setDimension(gcn::Rectangle(x, y, win_w - x, win_h - y));
        logic();
    }

    resize_in_progress = false;
}
