/*
 * gui_button.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "gui_button.hpp"
#include "gui_draw_box.hpp"

void GuiButton::draw(gcn::Graphics *graphics)
{
    const BoxCol BUTTON_BOXCOL = { 250, 250, 150, 210, 180, 100 };
    const BoxCol BUTTON_BOXCOL_PRESSED = { 210, 180, 100, 210, 180, 100 };
    
    if (isPressed()) {
        GuiDrawBox(graphics, BUTTON_BOXCOL_PRESSED, 0, 0, getWidth(), getHeight());
    } else {
        GuiDrawBox(graphics, BUTTON_BOXCOL, 0, 0, getWidth(), getHeight());
    }
    
    int textX = 0;
    int textY = getHeight() / 2 - getFont()->getHeight() / 2;
    
    switch (getAlignment()) {
    case gcn::Graphics::LEFT: textX = getSpacing(); break;
    case gcn::Graphics::CENTER: textX = getWidth() / 2; break;
    case gcn::Graphics::RIGHT: textX = getWidth() - getSpacing(); break;
    }
    
    graphics->setFont(getFont());
    if (isPressed()) {
        graphics->drawText(getCaption(), textX+1, textY+1, getAlignment());
    } else {
        graphics->drawText(getCaption(), textX, textY, getAlignment());
    }
}
