/*
 * graphic_transform.hpp
 *
 * Resizing and Colour-Changing of graphics
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef GRAPHIC_TRANSFORM_HPP
#define GRAPHIC_TRANSFORM_HPP

#include "gfx/pixel_array.hpp"  // coercri

#include "boost/shared_ptr.hpp"

class ColourChange;
class GfxResizer;

boost::shared_ptr<const Coercri::PixelArray> CreateGraphicWithCC(boost::shared_ptr<const Coercri::PixelArray> original,
                                                          const ColourChange &cc);
boost::shared_ptr<const Coercri::PixelArray> CreateResizedGraphic(const GfxResizer &resizer,
                                                           boost::shared_ptr<const Coercri::PixelArray> original,
                                                           int new_width, int new_height,
                                                           int old_hx, int old_hy, int &new_hx, int &new_hy);

#endif
